/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.entity;

import java.util.UUID;
import net.adventurez.init.SoundInit;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class BrownFungusEntity
extends PathfinderMob
implements NeutralMob {
    private static final UniformInt ANGER_TIME_RANGE = TimeUtil.m_145020_((int)20, (int)60);
    private int angerTime;
    private UUID angryAt;

    public BrownFungusEntity(EntityType<? extends PathfinderMob> entityType, Level world) {
        super(entityType, world);
        this.m_274367_(1.0f);
        this.f_21364_ = 2;
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_41867_}), false));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((BrownFungusEntity)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
    }

    public static AttributeSupplier.Builder createBrownFungusAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.2).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22277_, 32.0);
    }

    public static boolean canSpawn(EntityType<BrownFungusEntity> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_184231_) && world.m_45524_(pos, 0) > 8;
    }

    protected SoundEvent m_7515_() {
        return SoundInit.FUNGUS_IDLE_EVENT;
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return SoundInit.FUNGUS_HURT_EVENT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.FUNGUS_DEATH_EVENT;
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12624_, 0.15f, 1.0f);
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        this.m_21678_(nbt);
    }

    public void m_7378_(CompoundTag nbt) {
        super.m_7378_(nbt);
        this.m_147285_(this.m_9236_(), nbt);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().m_5776_()) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
            int randomMushroom = this.m_9236_().m_213780_().m_188503_(20000);
            if (randomMushroom == 1997 && (this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60713_(Blocks.f_50195_) || this.m_9236_().m_8055_(this.m_20183_().m_7495_()).m_60713_(Blocks.f_50440_)) && this.m_9236_().m_8055_(this.m_20183_()).m_60795_()) {
                this.m_9236_().m_46597_(this.m_20183_(), Blocks.f_50072_.m_49966_());
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7640_() != null && source.m_7640_() instanceof Player) {
            Player attacker = (Player)source.m_7640_();
            this.m_6925_(attacker.m_20148_());
        }
        return this.m_6673_(source) ? false : super.m_6469_(source, amount);
    }

    public void m_6825_() {
        this.m_7870_(ANGER_TIME_RANGE.m_214085_(this.f_19796_));
    }

    public void m_7870_(int ticks) {
        this.angerTime = ticks;
    }

    public int m_6784_() {
        return this.angerTime;
    }

    public void m_6925_(@Nullable UUID uuid) {
        this.angryAt = uuid;
    }

    public UUID m_6120_() {
        return this.angryAt;
    }

    public float m_6431_(Pose pose, EntityDimensions dimensions) {
        return dimensions.f_20378_ * 0.6f;
    }

    public int m_5792_() {
        return 4;
    }

    public boolean m_7327_(Entity target) {
        if (!super.m_7327_(target)) {
            return false;
        }
        if (!this.m_9236_().m_5776_() && target instanceof LivingEntity && this.m_9236_().m_213780_().m_188503_(160) > 100) {
            ((LivingEntity)target).m_147207_(new MobEffectInstance(MobEffect.m_19453_((int)19), 80 + this.m_9236_().m_213780_().m_188503_(100), 0, false, false), (Entity)this);
        }
        return true;
    }
}

